package nemosofts.voxradio.activity;

import static android.Manifest.permission.READ_EXTERNAL_STORAGE;
import static android.Manifest.permission.READ_MEDIA_AUDIO;
import static android.Manifest.permission.WRITE_EXTERNAL_STORAGE;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;

import androidx.activity.EdgeToEdge;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.appcompat.app.ActionBarDrawerToggle;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.appcompat.widget.PopupMenu;
import androidx.appcompat.widget.Toolbar;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.Insets;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.GravityCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.media3.common.util.UnstableApi;
import androidx.nemosofts.AppCompatActivity;
import androidx.nemosofts.material.BlurImage;
import androidx.nemosofts.material.ImageHelperView;
import androidx.nemosofts.material.PlayPauseButton;
import androidx.nemosofts.material.ToggleView;
import androidx.nemosofts.theme.ColorUtils;
import androidx.nemosofts.theme.ThemeEngine;
import androidx.nemosofts.utils.NetworkUtils;
import androidx.palette.graphics.Palette;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;

import com.google.android.material.navigation.NavigationView;
import com.google.android.material.progressindicator.CircularProgressIndicator;
import com.google.android.material.textview.MaterialTextView;
import com.jetradarmobile.snowfall.SnowfallView;
import com.sothree.slidinguppanel.SlidingUpPanelLayout;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Target;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.util.concurrent.TimeUnit;

import nemosofts.voxradio.BuildConfig;
import nemosofts.voxradio.R;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.callback.Method;
import nemosofts.voxradio.dialog.DialogUtil;
import nemosofts.voxradio.dialog.FeedBackDialog;
import nemosofts.voxradio.dialog.ReviewDialog;
import nemosofts.voxradio.executor.LoadStatus;
import nemosofts.voxradio.interfaces.SuccessListener;
import nemosofts.voxradio.item.ItemPodcasts;
import nemosofts.voxradio.item.ItemRadio;
import nemosofts.voxradio.utils.ApplicationUtil;
import nemosofts.voxradio.utils.AudioRecorder;
import nemosofts.voxradio.utils.GlobalBus;
import nemosofts.voxradio.utils.IfSupported;
import nemosofts.voxradio.utils.LoadColor;
import nemosofts.voxradio.utils.MessageEvent;
import nemosofts.voxradio.utils.helper.DBHelper;
import nemosofts.voxradio.utils.helper.Helper;
import nemosofts.voxradio.utils.helper.SPHelper;

public class NSoftsPlayerActivity extends AppCompatActivity implements View.OnClickListener {

    private static final String TAG_ACTIVITY = "NSoftsPlayerActivity";
    ThemeEngine themeEngine;
    Helper helper;
    DBHelper dbHelper;
    SPHelper spHelper;
    Toolbar toolbar;
    DrawerLayout drawer;
    NavigationView navigationView;

    AudioManager am;
    Boolean isExpand = false;
    SlidingUpPanelLayout mLayout;

    // MINI PLAYER ---------------------------------------------------------------------------------
    LinearLayout bottomNav;
    ToggleView navHome;
    ToggleView navLatest;
    ToggleView navMost;
    ToggleView navCategory;
    ToggleView navRestore;
    RelativeLayout minHeader;
    LinearLayout adViewPlayer;
    ImageView minPrevious;
    ImageView minPlay;
    ImageView minNext;
    ProgressBar pbMin;
    CircularProgressIndicator circularMin;
    ProgressBar progressBarMin;
    MaterialTextView minTitle;
    Handler seekHandler = new Handler(Looper.getMainLooper());

    // MAIN PLAYER ---------------------------------------------------------------------------------
    public ViewPager viewpager;
    ImagePagerAdapter adapter;
    ImageView volumeDown;
    ImageView volumeUp;
    RelativeLayout musicLoading;
    PlayPauseButton playPauseButton;
    SeekBar seekBarMusic;
    TextView currentTime;
    TextView totalTime;
    ImageView musicPrevious;
    ImageView musicNext;
    ImageView microphone;
    TextView musicTitle;
    TextView musicArtist;
    TextView songCount;
    RatingBar ratingBar;
    AudioManager audioManager;
    SeekBar volumeSeekBar;
    Boolean isExpandVolume = true;
    ImageView radioTimer;
    TextView timer;
    // Option --------------------------------------------------------------------------------------
    ImageView optionEqualizer;
    ImageView optionRate;
    ImageView optionFav;
    ImageView optionShare;
    ImageView optionBug;
    ImageView optionPlayer;
    View musicOptions;
    View mediaSeekbar;

    @OptIn(markerClass = UnstableApi.class)
    @SuppressLint("SetTextI18n")
    @Override
    public void onCreate(Bundle savedInstanceState) {
        spHelper = new SPHelper(this);
        spHelper.getThemeDetails();
        super.onCreate(savedInstanceState);
        IfSupported.isRTL(this);
        IfSupported.isScreenshot(this);

        EdgeToEdge.enable(this);
        // Window Insets padding for drawer layout
        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.drawer_layout), (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
            return insets;
        });
        // Window Insets padding for background page
        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.sliding_layout), (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
            return insets;
        });

        Callback.context = this;
        am = (AudioManager) getSystemService(Context.AUDIO_SERVICE);

        helper = new Helper(this);
        dbHelper = new DBHelper(this);
        themeEngine = new ThemeEngine(this);

        toolbar = findViewById(R.id.toolbar_offline_music);
        setSupportActionBar(toolbar);
        drawer = findViewById(R.id.drawer_layout);
        navigationView = findViewById(R.id.nav_view);
        ActionBarDrawerToggle toggle = new ActionBarDrawerToggle(
                this, drawer, toolbar, R.string.navigation_drawer_open, R.string.navigation_drawer_close);
        toggle.setDrawerIndicatorEnabled(false);
        toggle.setHomeAsUpIndicator(R.drawable.ic_menu);
        toggle.setToolbarNavigationClickListener(view -> drawer.openDrawer(GravityCompat.START));
        drawer.addDrawerListener(toggle);
        toggle.syncState();

        Drawable navigationIcon = toolbar.getNavigationIcon();
        if (navigationIcon != null) {
            navigationIcon = DrawableCompat.wrap(navigationIcon);
            DrawableCompat.setTint(navigationIcon, ContextCompat.getColor(NSoftsPlayerActivity.this,
                    Boolean.TRUE.equals(themeEngine.getIsThemeMode()) ? R.color.ns_white : R.color.ns_black));
            toolbar.setNavigationIcon(navigationIcon);
        }

        //  MINI PLAYER ----------------------------------------------------------------------------
        bottomNav = findViewById(R.id.ll_bottom_nav);
        adViewPlayer = findViewById(R.id.ll_adView_player);
        adViewPlayer.setVisibility(View.GONE);

        navHome = findViewById(R.id.tv_nav_home);
        navHome.setBadgeText("");
        navLatest = findViewById(R.id.tv_nav_latest);
        navMost = findViewById(R.id.tv_nav_most);
        navCategory = findViewById(R.id.tv_nav_category);
        navRestore = findViewById(R.id.tv_nav_restore);

        mLayout = findViewById(R.id.sliding_layout);
        minHeader = findViewById(R.id.rl_min_header);
        minHeader.setOnClickListener(v -> {
        });

        findViewById(R.id.iv_open_player).setOnClickListener(v -> {
            if (mLayout.getPanelState() == SlidingUpPanelLayout.PanelState.COLLAPSED) {
                mLayout.setPanelState(SlidingUpPanelLayout.PanelState.EXPANDED);
            }
        });
        findViewById(R.id.iv_open_player_2).setOnClickListener(v -> {
            if (mLayout.getPanelState() == SlidingUpPanelLayout.PanelState.COLLAPSED) {
                mLayout.setPanelState(SlidingUpPanelLayout.PanelState.EXPANDED);
            }
        });

        progressBarMin = findViewById(R.id.progressBar_min);
        circularMin = findViewById(R.id.circular_min);
        minTitle = findViewById(R.id.tv_min_title);
        pbMin = findViewById(R.id.pb_min);
        minPrevious = findViewById(R.id.iv_min_previous);
        minPlay = findViewById(R.id.iv_min_play);
        minNext = findViewById(R.id.iv_min_next);
        microphone = findViewById(R.id.iv_radio_microphone);
        radioTimer = findViewById(R.id.iv_radio_timer);

        minPlay.setOnClickListener(this);
        minNext.setOnClickListener(this);
        minPrevious.setOnClickListener(this);
        microphone.setOnClickListener(this);
        radioTimer.setOnClickListener(this);

        // MAIN PLAYER -----------------------------------------------------------------------------
        audioManager = (AudioManager) getSystemService(Context.AUDIO_SERVICE);
        findViewById(R.id.rl_c).setOnClickListener(v -> {
        });

        volumeDown = findViewById(R.id.volumeDown);
        volumeUp = findViewById(R.id.volumeUp);
        musicLoading = findViewById(R.id.rl_music_loading);
        playPauseButton = findViewById(R.id.iv_music_play);
        seekBarMusic = findViewById(R.id.seekbar_music);
        currentTime = findViewById(R.id.tv_music_time);
        totalTime = findViewById(R.id.tv_music_total_time);
        musicPrevious = findViewById(R.id.iv_music_previous);
        musicNext = findViewById(R.id.iv_music_next);
        ratingBar = findViewById(R.id.rb_music);
        musicTitle = findViewById(R.id.tv_music_title);
        musicArtist = findViewById(R.id.tv_music_artist);
        songCount = findViewById(R.id.tv_music_song_count);
        volumeSeekBar = findViewById(R.id.volumeSeekBar);

        currentTime.setText("00:00");
        totalTime.setText("00:00");

        optionEqualizer = findViewById(R.id.iv_player_equalizer);
        optionRate = findViewById(R.id.iv_player_rate);
        optionFav = findViewById(R.id.iv_player_fav);
        optionShare = findViewById(R.id.iv_player_share);
        optionBug = findViewById(R.id.iv_player_bug);
        optionPlayer = findViewById(R.id.iv_player_option);

        musicOptions = findViewById(R.id.music_player_options);
        mediaSeekbar = findViewById(R.id.media_seekbar);

        playPauseButton.setOnClickListener(this);
        musicPrevious.setOnClickListener(this);
        musicNext.setOnClickListener(this);
        optionEqualizer.setOnClickListener(this);
        optionRate.setOnClickListener(this);
        optionFav.setOnClickListener(this);
        optionShare.setOnClickListener(this);
        optionBug.setOnClickListener(this);
        optionPlayer.setOnClickListener(this);

        adapter = new ImagePagerAdapter();

        viewpager = findViewById(R.id.viewPager_song);
        viewpager.setOffscreenPageLimit(5);

        setVolumeSeekBar();
        setPanelSlideListener();
        setPageChangeListener();
        setSeekBarChangeListener();
        setFallView();

        if (Callback.getNowPlayingScreen() == 3 || Callback.getNowPlayingScreen() == 4){
            loadIconColor();
        }

        musicLoading.setOnClickListener( v -> {
            if (PlayerService.getInstance() != null && musicLoading.getVisibility() == View.VISIBLE) {
                Intent intent = new Intent(NSoftsPlayerActivity.this, PlayerService.class);
                intent.setAction(PlayerService.ACTION_STOP);
                startService(intent);
                Toast.makeText(NSoftsPlayerActivity.this, "Stop Audio", Toast.LENGTH_SHORT).show();
                GlobalBus.getBus().postSticky(new MessageEvent(false, "buffer"));
            }
        });

        timer = findViewById(R.id.textView_timer);
        if (Boolean.TRUE.equals(spHelper.getIsSleepTimeOn())) {
            spHelper.setCheckSleepTime();
            updateTimer(spHelper.getSleepTime());
        }
        getRecording();
    }

    private void setFallView() {
        SnowfallView snowFall = findViewById(R.id.view_snow_fall);
        if (Boolean.TRUE.equals(themeEngine.getIsThemeMode() || Callback.getNowPlayingScreen() == 3) || Callback.getNowPlayingScreen() == 4){
            if (Boolean.TRUE.equals(spHelper.isSnowFall())){
                snowFall.restartFalling();
            } else {
                snowFall.stopFalling();
            }
            snowFall.setVisibility(Boolean.TRUE.equals(spHelper.isSnowFall()) ? View.VISIBLE : View.GONE);
        } else {
            snowFall.stopFalling();
            snowFall.setVisibility(View.GONE);
        }
    }

    private void setSeekBarChangeListener() {
        seekBarMusic.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                // this method is empty
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
                // this method is empty
            }

            @OptIn(markerClass = UnstableApi.class)
            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                int progress = seekBar.getProgress();
                try {
                    Intent intent = new Intent(NSoftsPlayerActivity.this, PlayerService.class);
                    intent.setAction(PlayerService.ACTION_SEEKTO);
                    intent.putExtra("seekto", ApplicationUtil.getSeekFromPercentage(progress, PlayerService.getInstance().getDuration()));
                    startService(intent);
                } catch (Exception e) {
                    Log.e(TAG_ACTIVITY, "Error seekBarMusic", e);
                }
            }
        });
    }

    private void setPageChangeListener() {
        viewpager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                // this method is empty
            }

            @Override
            public void onPageSelected(int position) {
                changeTextPager(Callback.getArrayListPlay().get(position));

                View view = viewpager.findViewWithTag("myview" + position);
                if (view != null) {
                    ImageView iv = view.findViewById(R.id.iv_vp_play);
                    if (Callback.getPlayPos() == position) {
                        iv.setVisibility(View.GONE);
                    } else {
                        iv.setVisibility(View.VISIBLE);
                    }
                }
            }

            @Override
            public void onPageScrollStateChanged(int state) {
                // this method is empty
            }
        });
    }

    private void setPanelSlideListener() {
        mLayout.addPanelSlideListener(new SlidingUpPanelLayout.PanelSlideListener() {
            @Override
            public void onPanelSlide(View panel, float slideOffset) {
                if (slideOffset == 0.0f) {
                    isExpand = false;
                    minHeader.setVisibility(View.VISIBLE);
                    minHeader.setAlpha(1.0f); // Ensure it's fully visible.
                } else if (slideOffset < 1.0f) { // Implies slideOffset > 0.0f.
                    minHeader.setVisibility(View.VISIBLE);
                    minHeader.setAlpha(1.0f - slideOffset);
                } else { // Implies slideOffset == 1.0f.
                    isExpand = true;
                    minHeader.setVisibility(View.INVISIBLE);
                }
            }

            @Override
            public void onPanelStateChanged(View panel, SlidingUpPanelLayout.PanelState previousState, SlidingUpPanelLayout.PanelState newState) {
                if (newState == SlidingUpPanelLayout.PanelState.EXPANDED) {
                    try {
                        boolean shouldSetAdapter = viewpager.getAdapter() == null
                                || Callback.getIsNewAdded()
                                || !Callback.getAddedFrom().equals(adapter.getIsLoadedFrom());
                        if (shouldSetAdapter) {
                            viewpager.setAdapter(adapter);
                        }
                        viewpager.setCurrentItem(Callback.getPlayPos());
                    } catch (Exception e) {
                        adapter.notifyDataSetChanged();
                        viewpager.setCurrentItem(Callback.getPlayPos());
                    }
                    volumeAnimator();
                }
            }
        });
    }

    private void volumeAnimator() {
        if (Boolean.TRUE.equals(spHelper.isVolume()
                && volumeSeekBar.getVisibility() == View.VISIBLE)
                && volumeSeekBar.getProgress() != audioManager.getStreamVolume(AudioManager.STREAM_MUSIC)){

            ValueAnimator anim = ValueAnimator.ofInt(volumeSeekBar.getProgress(), audioManager.getStreamVolume(AudioManager.STREAM_MUSIC));
            anim.setDuration(400);
            anim.addUpdateListener(animation -> {
                int animProgress = (Integer) animation.getAnimatedValue();
                volumeSeekBar.setProgress(animProgress);
            });
            anim.addListener(new Animator.AnimatorListener() {
                @Override
                public void onAnimationStart(@NonNull Animator animator) {
                    isExpandVolume = false;
                }

                @Override
                public void onAnimationEnd(@NonNull Animator animator) {
                    isExpandVolume = true;
                }

                @Override
                public void onAnimationCancel(@NonNull Animator animator) {
                    isExpandVolume = true;
                }

                @Override
                public void onAnimationRepeat(@NonNull Animator animator) {
                    // this method is empty
                }
            });
            anim.start();
        }
    }

    private void setVolumeSeekBar() {
        volumeSeekBar.setMax(audioManager.getStreamMaxVolume(AudioManager.STREAM_MUSIC));
        int volumeLevel = am.getStreamVolume(AudioManager.STREAM_MUSIC);
        volumeSeekBar.setProgress(volumeLevel);
        volumeSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int i, boolean b) {
                if (Boolean.TRUE.equals(isExpandVolume)){
                    audioManager.setStreamVolume(AudioManager.STREAM_MUSIC, i, 0);
                    if (volumeDown.getVisibility() == View.VISIBLE && i == 0){
                        volumeDown.setImageResource(R.drawable.ic_volume_mute);
                    } else {
                        volumeDown.setImageResource(R.drawable.ic_volume_down);
                    }
                }
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
                // this method is empty
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                // this method is empty
            }
        });

        volumeSeekBar.setVisibility(Boolean.TRUE.equals(spHelper.isVolume()) ? View.VISIBLE : View.GONE);
        volumeDown.setVisibility(Boolean.TRUE.equals(spHelper.isVolume()) ? View.VISIBLE : View.GONE);
        volumeUp.setVisibility(Boolean.TRUE.equals(spHelper.isVolume()) ? View.VISIBLE : View.GONE);
    }

    private void loadIconColor() {
        musicTitle.setTextColor(ColorUtils.colorWhite(this));
        musicArtist.setTextColor(ColorUtils.colorWhite(this));
        songCount.setTextColor(ColorUtils.colorWhite(this));
        currentTime.setTextColor(ColorUtils.colorWhite(this));
        totalTime.setTextColor(ColorUtils.colorWhite(this));
        seekBarMusic.setBackgroundTintList(ColorStateList.valueOf(ColorUtils.colorWhite(this)));

        volumeDown.setColorFilter(ColorUtils.colorWhite(this));
        volumeUp.setColorFilter(ColorUtils.colorWhite(this));

        musicPrevious.setColorFilter(ColorUtils.colorWhite(this));
        musicNext.setColorFilter(ColorUtils.colorWhite(this));

        optionEqualizer.setColorFilter(ColorUtils.colorWhite(this));
        optionRate.setColorFilter(ColorUtils.colorWhite(this));
        optionFav.setColorFilter(ColorUtils.colorWhite(this));
        optionShare.setColorFilter(ColorUtils.colorWhite(this));
        optionBug.setColorFilter(ColorUtils.colorWhite(this));
        optionPlayer.setColorFilter(ColorUtils.colorWhite(this));

        microphone.setImageResource(R.drawable.ic_microphone2);
        radioTimer.setColorFilter(ColorUtils.colorWhite(this));
    }

    @SuppressLint("SetTextI18n")
    private void changeTextPager(ItemRadio itemRadio) {
        if (itemRadio != null) {
            ratingBar.setRating(Integer.parseInt(itemRadio.getAverageRating()));
            musicArtist.setText(itemRadio.getCategoryName());
            musicTitle.setText(itemRadio.getRadioTitle());
            songCount.setText((viewpager.getCurrentItem() + 1) + "/" + Callback.getArrayListPlay().size());
        }
    }

    @SuppressLint("SetTextI18n")
    public void changeText(@NonNull ItemRadio itemRadio) {
        //  MINI PLAYER ----------------------------------------------------------------------------
        String artistName="";
        if (!itemRadio.getCategoryName().isEmpty()) {
            artistName = itemRadio.getCategoryName();
        }
        String subName = itemRadio.getRadioTitle() +" • "+ artistName;
        minTitle.setText(subName);
        if (!minTitle.getText().toString().isEmpty()){
            minTitle.setSelected(true);
        }

        // MAIN PLAYER -----------------------------------------------------------------------------
        ratingBar.setRating(Integer.parseInt(itemRadio.getAverageRating()));
        musicTitle.setText(itemRadio.getRadioTitle());
        musicArtist.setText(itemRadio.getCategoryName());
        songCount.setText(Callback.getPlayPos() + 1 + "/" + Callback.getArrayListPlay().size());
        changeFav(itemRadio.getIsFav());

        ratingBar.setVisibility(Boolean.TRUE.equals(Callback.getIsRadio()) ? View.VISIBLE : View.INVISIBLE);
        musicOptions.setVisibility(Boolean.TRUE.equals(Callback.getIsRadio()) ? View.VISIBLE : View.INVISIBLE);

        circularMin.setVisibility(Boolean.TRUE.equals(Callback.getIsRadio()) ? View.INVISIBLE : View.VISIBLE);
        progressBarMin.setVisibility(Boolean.TRUE.equals(Callback.getIsRadio()) ? View.INVISIBLE : View.VISIBLE);
        mediaSeekbar.setVisibility(Boolean.TRUE.equals(Callback.getIsRadio()) ? View.INVISIBLE : View.VISIBLE);

        if (Callback.getNowPlayingScreen() == 2){
            loadColorTitle(itemRadio);
        }

        if (Callback.getNowPlayingScreen() == 3){
            ImageView bgPlayerBlur = findViewById(R.id.iv_bg_player_blur);
            bgPlayerBlur.setImageResource(R.drawable.shadow_up_now_play);
            new LoadColor(bgPlayerBlur).execute(itemRadio.getImage());
        }

        if (Callback.getNowPlayingScreen() == 4){
            loadBgBlur(itemRadio);
        }

        if (viewpager.getAdapter() == null || Callback.getIsNewAdded() || !Callback.getAddedFrom().equals(adapter.getIsLoadedFrom())) {
            viewpager.setAdapter(adapter);
            Callback.setIsNewAdded(false);
        }
        try {
            viewpager.setCurrentItem(Callback.getPlayPos());
        } catch (Exception e) {
            adapter.notifyDataSetChanged();
            viewpager.setCurrentItem(Callback.getPlayPos());
        }
    }

    private void loadBgBlur(ItemRadio itemRadio) {
        final  ImageView bgPlayerBlur = findViewById(R.id.iv_bg_player_blur);
        try {
            Target target = new Target() {
                @Override
                public void onBitmapLoaded(Bitmap bitmap, Picasso.LoadedFrom from) {
                    try {
                        int blurAmount = spHelper.getBlurAmount();
                        if (blurAmount >= 0 && blurAmount < 6) {
                            bgPlayerBlur.setImageBitmap(BlurImage.fastBlur(bitmap, 1f, 5));
                        }else {
                            bgPlayerBlur.setImageBitmap(BlurImage.fastBlur(bitmap, 1f, blurAmount));
                        }
                        findViewById(R.id.iv_bg_blur).setVisibility(View.VISIBLE);
                    } catch (Exception e) {
                        Log.e(TAG_ACTIVITY, "Error loadBgBlur", e);
                    }
                }

                @Override
                public void onBitmapFailed(Exception e, Drawable errorDrawable) {
                    bgPlayerBlur.setImageResource(R.drawable.shadow_up_now_play);
                    findViewById(R.id.iv_bg_blur).setVisibility(View.INVISIBLE);
                }
                @Override
                public void onPrepareLoad(Drawable placeHolderDrawable) {
                    // this method is empty
                }
            };
            bgPlayerBlur.setTag(target);
            Picasso.get()
                    .load(itemRadio.getImage())
                    .placeholder(R.drawable.material_design_default)
                    .into(target);
        } catch (Exception e) {
            bgPlayerBlur.setImageResource(R.drawable.shadow_up_now_play);
            findViewById(R.id.iv_bg_blur).setVisibility(View.INVISIBLE);
        }
    }

    private void loadColorTitle(ItemRadio itemRadio) {
        try {
            Picasso.get()
                    .load(itemRadio.getImage())
                    .centerCrop()
                    .resize(100, 100)
                    .into(new Target() {
                        @Override
                        public void onBitmapLoaded(Bitmap bitmap, Picasso.LoadedFrom from) {
                            try {
                                Palette.from(bitmap).generate(palette -> {
                                    if (palette != null) {
                                        Palette.Swatch textSwatch = palette.getVibrantSwatch();
                                        if (textSwatch != null) {
                                            musicTitle.setBackgroundTintList(ColorStateList.valueOf(textSwatch.getRgb()));
                                            musicArtist.setBackgroundTintList(ColorStateList.valueOf(textSwatch.getRgb()));
                                            musicTitle.setTextColor(ColorUtils.colorWhite(NSoftsPlayerActivity.this));
                                            musicArtist.setTextColor(ColorUtils.colorWhite(NSoftsPlayerActivity.this));
                                        }
                                    }
                                });
                            } catch (Exception e) {
                                Log.e(TAG_ACTIVITY, "Error loadColorTitle", e);
                            }
                        }
                        @Override
                        public void onBitmapFailed(Exception e, Drawable errorDrawable) {
                            // this method is empty
                        }
                        @Override
                        public void onPrepareLoad(Drawable placeHolderDrawable) {
                            // this method is empty
                        }
                    });
        } catch (Exception e) {
            Log.e(TAG_ACTIVITY, "Error loadColorTitle", e);
        }
    }

    private class ImagePagerAdapter extends PagerAdapter {

        private final LayoutInflater inflater;
        private String loadedPage = "";

        private ImagePagerAdapter() {
            inflater = getLayoutInflater();
        }

        @Override
        public int getCount() {
            return Callback.getArrayListPlay().size();
        }

        @Override
        public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
            return view.equals(object);
        }

        String getIsLoadedFrom() {
            return loadedPage;
        }

        @OptIn(markerClass = UnstableApi.class)
        @NonNull
        @Override
        public Object instantiateItem(@NonNull ViewGroup container, int position) {
            View imageLayout;
            boolean isTextColor = switch (Callback.getNowPlayingScreen()) {
                case 1 -> {
                    imageLayout = inflater.inflate(R.layout.row_viewpager_player_circle, container, false);
                    yield false;
                }
                case 2 -> {
                    imageLayout = inflater.inflate(R.layout.row_viewpager_player_flat, container, false);
                    yield true;
                }
                case 5 -> {
                    imageLayout = inflater.inflate(R.layout.row_viewpager_player_corner, container, false);
                    yield true;
                }
                case 6 -> {
                    imageLayout = inflater.inflate(R.layout.row_viewpager_player_corner_bottom, container, false);
                    yield true;
                }
                default -> {
                    imageLayout = inflater.inflate(R.layout.row_viewpager_player_normal, container, false);
                    yield true;
                }
            };

            ImageHelperView imageView = imageLayout.findViewById(R.id.image);
            final ImageView imageViewPlay = imageLayout.findViewById(R.id.iv_vp_play);
            final ProgressBar spinner = imageLayout.findViewById(R.id.loading);
            final RelativeLayout rlText = imageLayout.findViewById(R.id.rl_text);

            loadedPage = Callback.getAddedFrom();

            if (Callback.getPlayPos() == position) {
                imageViewPlay.setVisibility(View.GONE);
            }

            Picasso.get()
                    .load(Callback.getArrayListPlay().get(position).getImage())
                    .placeholder(R.drawable.material_design_default)
                    .into(imageView, new com.squareup.picasso.Callback() {
                        @Override
                        public void onSuccess() {
                            spinner.setVisibility(View.GONE);
                        }

                        @Override
                        public void onError(Exception e) {
                            spinner.setVisibility(View.GONE);
                        }
                    });

            if (isTextColor) {
                Picasso.get()
                        .load(Callback.getArrayListPlay().get(position).getImage())
                        .centerCrop()
                        .resize(100, 100)
                        .into(new Target() {
                            @Override
                            public void onBitmapLoaded(Bitmap bitmap, Picasso.LoadedFrom from) {
                                try {
                                    Palette.from(bitmap).generate(palette -> {
                                        if (palette != null) {
                                            Palette.Swatch textSwatch = palette.getVibrantSwatch();
                                            if (textSwatch != null) {
                                                rlText.setBackgroundTintList(ColorStateList.valueOf(textSwatch.getRgb()));
                                            }
                                        }
                                    });
                                } catch (Exception e) {
                                    Log.e(TAG_ACTIVITY, "Error ImagePagerAdapter Palette", e);
                                }
                            }

                            @Override
                            public void onBitmapFailed(Exception e, Drawable errorDrawable) {
                                // this method is empty
                            }

                            @Override
                            public void onPrepareLoad(Drawable placeHolderDrawable) {
                                // this method is empty
                            }
                        });
            }
            imageViewPlay.setOnClickListener(v -> startPlayerService(imageViewPlay));

            imageLayout.setTag("myview" + position);
            container.addView(imageLayout, 0);
            return imageLayout;
        }

        @Override
        public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
            container.removeView((View) object);
        }
    }

    @OptIn(markerClass = UnstableApi.class)
    public void startPlayerService(ImageView imageViewPlay) {
        if (isFinishing()){
            return;
        }
        if (NetworkUtils.isConnected(NSoftsPlayerActivity.this)) {
            try {
                Callback.setPlayPos(viewpager.getCurrentItem());
                Intent intent = new Intent(NSoftsPlayerActivity.this, PlayerService.class);
                intent.setAction(PlayerService.ACTION_PLAY);
                startService(intent);
                imageViewPlay.setVisibility(View.GONE);
            } catch (Exception e) {
                Log.e(TAG_ACTIVITY, "Error PlayerService", e);
            }
        } else {
            Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
        }
    }

    private final Runnable run = this::seekUpdating;

    @OptIn(markerClass = UnstableApi.class)
    public void seekUpdating() {
        if (Boolean.FALSE.equals(Callback.getIsRadio())){
            try {
                circularMin.setProgress(ApplicationUtil.getProgressPercentage(PlayerService.getExoPlayer().getCurrentPosition(), PlayerService.getInstance().getDuration()));
                progressBarMin.setProgress(ApplicationUtil.getProgressPercentage(PlayerService.getExoPlayer().getCurrentPosition(), PlayerService.getInstance().getDuration()));

                seekBarMusic.setProgress(ApplicationUtil.getProgressPercentage(PlayerService.getExoPlayer().getCurrentPosition(), PlayerService.getInstance().getDuration()));
                currentTime.setText(ApplicationUtil.milliSecondsToTimer(PlayerService.getExoPlayer().getCurrentPosition(), PlayerService.getInstance().getDuration()));
                totalTime.setText(ApplicationUtil.milliSecondsToTimer(PlayerService.getExoPlayer().getDuration(), PlayerService.getInstance().getDuration()));
                seekBarMusic.setSecondaryProgress(PlayerService.getExoPlayer().getBufferedPercentage());

                if (PlayerService.getExoPlayer().getPlayWhenReady() && Boolean.TRUE.equals(Callback.getIsAppOpen())) {
                    seekHandler.removeCallbacks(run);
                    seekHandler.postDelayed(run, 1000);
                }
            } catch (Exception e) {
                Log.e(TAG_ACTIVITY, "Error seekUpdating", e);
            }
        }
    }

    @Override
    public void onClick(View view) {
        if (view == null){
            return;
        }
        int id = view.getId();
        if (isPlayButton(id)) {
            playPause();
        } else if (isNextButton(id)) {
            next();
        } else if (isPreviousButton(id)) {
            previous();
        } else if (id == R.id.iv_radio_microphone){
            recordRadio();
        } else if (id == R.id.iv_player_equalizer){
            openEqualizer();
        } else if (id == R.id.iv_player_rate){
            showRateDialog();
        } else if (id == R.id.iv_player_fav){
            loadFav();
        } else if (id == R.id.iv_player_share){
            shareIntent();
        } else if (id == R.id.iv_player_bug){
            feedBackDialog();
        } else if (id == R.id.iv_player_option){
            openOptionPopUp();
        } else if (id == R.id.iv_radio_timer){
            if (Boolean.FALSE.equals(new SPHelper(this).getIsSleepTimeOn())) {
                setStartTimer();
            } else {
                setCancelTimer();
            }
        }
    }

    private boolean isPlayButton(int id) {
        return id == R.id.iv_min_play || id == R.id.iv_music_play;
    }

    private boolean isNextButton(int id) {
        return id == R.id.iv_min_next || id == R.id.iv_music_next;
    }

    private boolean isPreviousButton(int id) {
        return id == R.id.iv_min_previous || id == R.id.iv_music_previous;
    }

    @OptIn(markerClass = UnstableApi.class)
    private void setStartTimer() {
        DialogUtil.timerStartDialog(this, (hours, minute) -> {
            String time = hours + ":" + minute;
            long totalTimer = ApplicationUtil.convertLong(time) + System.currentTimeMillis();

            int id = ApplicationUtil.getRandomValue(100);

            spHelper.setSleepTime(true, totalTimer, id);

            Intent intent = new Intent(this, PlayerService.class);
            intent.setAction(PlayerService.ACTION_START_TIMER);
            startService(intent);

            updateTimer(totalTimer);
        });
    }

    @OptIn(markerClass = UnstableApi.class)
    private void setCancelTimer() {
        DialogUtil.timerCancelDialog(this, () -> {
            timer.setVisibility(View.GONE);
            spHelper.setSleepTime(false, 0, 0);
            Intent intent = new Intent(this, PlayerService.class);
            intent.setAction(PlayerService.ACTION_STOP_TIMER);
            startService(intent);
            Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.stop_timer), Toast.LENGTH_SHORT).show();
        });
    }

    private void updateTimer(long totalTimer) {
        long timeLeft = totalTimer - System.currentTimeMillis();
        if (timeLeft > 0) {

            @SuppressLint("DefaultLocale")
            String hms = String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(timeLeft),
                    TimeUnit.MILLISECONDS.toMinutes(timeLeft) % TimeUnit.HOURS.toMinutes(1),
                    TimeUnit.MILLISECONDS.toSeconds(timeLeft) % TimeUnit.MINUTES.toSeconds(1));
            timer.setVisibility(View.VISIBLE);
            timer.setText(hms);

            new Handler(Looper.getMainLooper()).postDelayed(() -> {
                if (Boolean.TRUE.equals(spHelper.getIsSleepTimeOn())) {
                    updateTimer(totalTimer);
                } else {
                    timer.setVisibility(View.GONE);
                }
            }, 1000);
        } else {
            timer.setVisibility(View.GONE);
        }
    }

    private void openOptionPopUp() {
        ContextThemeWrapper ctw = new ContextThemeWrapper(NSoftsPlayerActivity.this,
                Boolean.TRUE.equals(themeEngine.getIsThemeMode())
                        ? R.style.PopupMenuDark
                        :  R.style.PopupMenuLight
        );
        PopupMenu popup = new PopupMenu(ctw, optionPlayer);
        popup.getMenuInflater().inflate(R.menu.popup_player_option, popup.getMenu());
        popup.setForceShowIcon(true);
        popup.setOnMenuItemClickListener(item -> {
            if (item.getItemId() == R.id.popup_description) {
                openWebActivity();
            }
            else if (item.getItemId() == R.id.popup_go_to_category) {
                openRadioByActivity();
            }
            else if (item.getItemId() == R.id.popup_drive_mode) {
                if (!Callback.getArrayListPlay().isEmpty()){
                    startActivity(new Intent(NSoftsPlayerActivity.this, DriveModeActivity.class));
                } else {
                    Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.error_no_radio_selected), Toast.LENGTH_SHORT).show();
                }
            }
            return true;
        });
        popup.show();
    }

    private void openRadioByActivity() {
        if (Callback.getArrayListPlay().isEmpty()){
            Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.error_no_radio_selected), Toast.LENGTH_SHORT).show();
            return;
        }

        Intent intent = new Intent(NSoftsPlayerActivity.this, RadioByActivity.class);
        intent.putExtra("type", getString(R.string.categories));
        intent.putExtra("id",  Callback.getArrayListPlay().get(viewpager.getCurrentItem()).getCatID());
        intent.putExtra("name",  Callback.getArrayListPlay().get(viewpager.getCurrentItem()).getCategoryName());
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        startActivity(intent);
    }

    private void openWebActivity() {
        if (Callback.getArrayListPlay().isEmpty()){
            Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.error_no_radio_selected), Toast.LENGTH_SHORT).show();
            return;
        }
        String radioID = Callback.getArrayListPlay().get(viewpager.getCurrentItem()).getId();
        String radioTitle = Callback.getArrayListPlay().get(viewpager.getCurrentItem()).getRadioTitle();
        Intent intent = new Intent(NSoftsPlayerActivity.this, WebActivity.class);
        intent.putExtra("web_url", BuildConfig.BASE_URL+"description-radio/"+radioID);
        intent.putExtra("page_title", radioTitle);
        startActivity(intent);
    }

    @OptIn(markerClass = UnstableApi.class)
    private void openEqualizer() {
        if(PlayerService.getInstance() != null && Callback.getIsPlayed()) {
            Intent intent = new Intent(NSoftsPlayerActivity.this, EqualizerActivity.class);
            startActivity(intent);
        } else {
            Toast.makeText(NSoftsPlayerActivity.this, "play a Radio", Toast.LENGTH_SHORT).show();
        }
    }

    private void loadFav() {
        if (Callback.getArrayListPlay().isEmpty()){
            Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.error_no_radio_selected), Toast.LENGTH_SHORT).show();
            return;
        }

        if (!spHelper.isLogged()) {
            helper.clickLogin();
        }

        if (!NetworkUtils.isConnected(this)) {
            Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
            return;
        }

        LoadStatus loadFav = new LoadStatus(new SuccessListener() {
            @Override
            public void onStart() {
                changeFav(!Callback.getArrayListPlay().get(viewpager.getCurrentItem()).getIsFav());
            }

            @Override
            public void onEnd(String success, String favSuccess, String message) {
                if (isFinishing()){
                    return;
                }
                if (success.equals("1")) {
                    Callback.getArrayListPlay().get(viewpager.getCurrentItem()).setIsFav(message.equals("Added to Favourite"));
                    changeFav(Callback.getArrayListPlay().get(viewpager.getCurrentItem()).getIsFav());
                    Toast.makeText(NSoftsPlayerActivity.this, message, Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.err_server_not_connected), Toast.LENGTH_SHORT).show();
                }
            }
        }, helper.getAPIRequest(Method.METHOD_DO_FAV, 0, Callback.getArrayListPlay().get(viewpager.getCurrentItem()).getId(), "", "", "", spHelper.getUserId(), "", "", "", "", "", "", "", null));
        loadFav.execute();
    }

    private void showRateDialog() {
        if (!Callback.getArrayListPlay().isEmpty()) {
            ReviewDialog reviewDialog = new ReviewDialog(this, new ReviewDialog.RatingDialogListener() {
                @Override
                public void onShow() {
                    // this method is empty
                }

                @Override
                public void onGetRating(String rating, String message) {
                    Callback.getArrayListPlay().get(viewpager.getCurrentItem()).setUserRating(String.valueOf(rating));
                    Callback.getArrayListPlay().get(viewpager.getCurrentItem()).setUserMessage(message);
                }

                @Override
                public void onDismiss(String success, String rateSuccess, String message, int rating, String userRating, String userMessage) {
                    if (isFinishing()){
                        return;
                    }

                    if (!success.equals("1")) {
                        Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.err_server_not_connected), Toast.LENGTH_SHORT).show();
                        return;
                    }

                    if (rateSuccess.equals("1")) {
                        try {
                            Callback.getArrayListPlay().get(viewpager.getCurrentItem()).setAverageRating(String.valueOf(rating));
                            Callback.getArrayListPlay().get(viewpager.getCurrentItem()).setTotalRate(String.valueOf(Integer.parseInt(Callback.getArrayListPlay().get(viewpager.getCurrentItem()).getTotalRate() + 1)));
                            Callback.getArrayListPlay().get(viewpager.getCurrentItem()).setUserRating(String.valueOf(userRating));
                            Callback.getArrayListPlay().get(viewpager.getCurrentItem()).setUserMessage(String.valueOf(userMessage));
                            ratingBar.setRating(rating);
                        } catch (Exception e) {
                            Log.e(TAG_ACTIVITY, "Error showRateDialog", e);
                        }
                    }
                    Toast.makeText(NSoftsPlayerActivity.this, message, Toast.LENGTH_SHORT).show();
                }
            });
            reviewDialog.showDialog(
                    Callback.getArrayListPlay().get(viewpager.getCurrentItem()).getId(),
                    Callback.getArrayListPlay().get(viewpager.getCurrentItem()).getUserRating(),
                    Callback.getArrayListPlay().get(viewpager.getCurrentItem()).getUserMessage()
            );
        } else {
            Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.err_no_data_found), Toast.LENGTH_SHORT).show();
        }
    }

    private void feedBackDialog() {
        if (!Callback.getArrayListPlay().isEmpty()) {
            new FeedBackDialog(this).showDialog(
                    Callback.getArrayListPlay().get(viewpager.getCurrentItem()).getId(),
                    Callback.getArrayListPlay().get(viewpager.getCurrentItem()).getRadioTitle()
            );
        } else {
            Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.err_no_data_found), Toast.LENGTH_SHORT).show();
        }
    }

    private void shareIntent() {
        if (!Callback.getArrayListPlay().isEmpty()){
            Intent sendIntent = new Intent();
            sendIntent.setAction(Intent.ACTION_SEND);
            sendIntent.putExtra(Intent.EXTRA_TEXT,
                    Callback.getArrayListPlay().get(viewpager.getCurrentItem()).getRadioTitle()+ "\n\n" +
                            Callback.getArrayListPlay().get(viewpager.getCurrentItem()).getCategoryName()+ "\n" +
                            "https://play.google.com/store/apps/details?id=" + getPackageName());
            sendIntent.setType("text/plain");
            startActivity(sendIntent);
        } else {
            Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.error_no_radio_selected), Toast.LENGTH_SHORT).show();
        }
    }

    private void recordRadio() {
        if (Boolean.TRUE.equals(checkPermission())) {
            if (Boolean.TRUE.equals(AudioRecorder.isRecording())) {
                stopRecording();
            } else if (canStartRecording()) {
                startRecording();
            } else {
                Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.not_start_fm), Toast.LENGTH_SHORT).show();
            }
        }
    }

    @OptIn(markerClass = UnstableApi.class)
    private boolean canStartRecording() {
        return PlayerService.getInstance() != null && Callback.getIsPlayed() && Boolean.TRUE.equals(Callback.getIsRadio());
    }

    private void stopRecording() {
        AudioRecorder.stopRecording();
        updateMicrophoneIcon(false);
        Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.recording_complete), Toast.LENGTH_SHORT).show();
    }

    private void startRecording() {
        new AudioRecorder(this).startRecording();
        updateMicrophoneIcon(true);
        Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.recording_start), Toast.LENGTH_SHORT).show();
    }

    private void updateMicrophoneIcon(boolean isRecording) {
        boolean isThemeMode = Boolean.TRUE.equals(themeEngine.getIsThemeMode());
        int iconRes;

        if (isRecording) {
            iconRes = isThemeMode || Callback.getNowPlayingScreen() == 3 || Callback.getNowPlayingScreen() == 4
                    ? R.drawable.ic_microphone_b
                    : R.drawable.ic_microphone_b2;
        } else {
            iconRes = isThemeMode || Callback.getNowPlayingScreen() == 3 || Callback.getNowPlayingScreen() == 4
                    ? R.drawable.ic_microphone2
                    : R.drawable.ic_microphone;
        }

        microphone.setImageResource(iconRes);
    }


    @OptIn(markerClass = UnstableApi.class)
    public void next() {
        handlePlayerAction(PlayerService.ACTION_NEXT);
    }

    @OptIn(markerClass = UnstableApi.class)
    public void previous() {
        handlePlayerAction(PlayerService.ACTION_PREVIOUS);
    }

    @OptIn(markerClass = UnstableApi.class)
    public void playPause() {
        if (!Callback.getArrayListPlay().isEmpty()) {
            String action = Boolean.TRUE.equals(Callback.getIsPlayed())
                    ? PlayerService.ACTION_TOGGLE
                    : PlayerService.ACTION_PLAY;
            handlePlayerAction(action);
        } else {
            Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.error_no_radio_selected), Toast.LENGTH_SHORT).show();
        }
    }

    @OptIn(markerClass = UnstableApi.class)
    private void handlePlayerAction(String action) {
        if (!Callback.getArrayListPlay().isEmpty()) {
            if (NetworkUtils.isConnected(this)) {
                Intent intent = new Intent(NSoftsPlayerActivity.this, PlayerService.class);
                intent.setAction(action);
                startService(intent);
            } else {
                Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
            }
        } else {
            Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.error_no_radio_selected), Toast.LENGTH_SHORT).show();
        }
    }

    public void changeFav(Boolean isFav) {
        optionFav.setImageDrawable(ContextCompat.getDrawable(this, Boolean.TRUE.equals(isFav) ? R.drawable.ic_heart_fill : R.drawable.ic_heart_line));
        if (Callback.getNowPlayingScreen() == 3 || Callback.getNowPlayingScreen() == 4){
            optionFav.setColorFilter(ColorUtils.colorWhite(NSoftsPlayerActivity.this));
        } else {
            optionFav.setColorFilter(ColorUtils.colorTitle(NSoftsPlayerActivity.this));
        }
    }

    @Override
    public int setContentViewID() {
        if (Callback.getNowPlayingScreen() == 2) {
            return R.layout.activity_base_flat;
        }
        return R.layout.activity_base_normal;
    }

    private void getRecording() {
        boolean isRecording = Boolean.TRUE.equals(AudioRecorder.isRecording());
        boolean isThemeMode = Boolean.TRUE.equals(themeEngine.getIsThemeMode());
        boolean isScreenSpecial = Callback.getNowPlayingScreen() == 3 || Callback.getNowPlayingScreen() == 4;

        int iconRes = getMicrophoneIcon(isRecording, isThemeMode, isScreenSpecial);
        microphone.setImageResource(iconRes);
    }

    private int getMicrophoneIcon(boolean isRecording, boolean isThemeMode, boolean isScreenSpecial) {
        if (isRecording) {
            return isThemeMode || isScreenSpecial ? R.drawable.ic_microphone_b : R.drawable.ic_microphone_b2;
        } else {
            return isThemeMode || isScreenSpecial ? R.drawable.ic_microphone2 : R.drawable.ic_microphone;
        }
    }

    public void changePlayPauseIcon(Boolean isPlay) {
        minPlay.setImageDrawable(ContextCompat.getDrawable(this, Boolean.FALSE.equals(isPlay) ? R.drawable.ic_play : R.drawable.ic_pause));
        playPauseButton.change(!isPlay);
        seekUpdating();
    }

    public void isBuffering(Boolean isBuffer) {
        if (isBuffer != null){
            if (Boolean.FALSE.equals(isBuffer)) {
                playPauseButton.setVisibility(View.VISIBLE);
                musicLoading.setVisibility(View.INVISIBLE);
                pbMin.setVisibility(View.INVISIBLE);
                changePlayPauseIcon(true);
            } else {
                playPauseButton.setVisibility(View.INVISIBLE);
                musicLoading.setVisibility(View.VISIBLE);
                pbMin.setVisibility(View.VISIBLE);
            }

            minNext.setEnabled(!isBuffer);
            minPrevious.setEnabled(!isBuffer);

            musicNext.setEnabled(!isBuffer);
            musicPrevious.setEnabled(!isBuffer);
            seekBarMusic.setEnabled(!isBuffer);
        }
    }

    @Subscribe(sticky = true, threadMode = ThreadMode.MAIN)
    public void onSongChange(ItemRadio itemRadio) {
        changeText(itemRadio);
        Callback.context = NSoftsPlayerActivity.this;
    }

    @Subscribe(sticky = true, threadMode = ThreadMode.MAIN)
    public void onBufferChange(@NonNull MessageEvent messageEvent) {
        if (messageEvent.message.equals("buffering")){
            isBuffering(messageEvent.flag);
        } else if (messageEvent.message.equals("buffer")) {
            isBuffering(messageEvent.flag);
        } else {
            changePlayPauseIcon(messageEvent.flag);
        }
        getRecording();
    }

    @SuppressLint("SetTextI18n")
    @Subscribe(sticky = true, threadMode = ThreadMode.MAIN)
    public void onViewPagerChanged(ItemPodcasts itemPodcasts) {
        adapter.notifyDataSetChanged();
        songCount.setText(Callback.getPlayPos() + 1 + "/" + Callback.getArrayListPlay().size());
        GlobalBus.getBus().removeStickyEvent(itemPodcasts);
    }


    @Override
    public void onStart() {
        super.onStart();
        GlobalBus.getBus().register(this);
    }

    @Override
    public void onStop() {
        GlobalBus.getBus().unregister(this);
        super.onStop();
    }

    @Override
    protected void onPause() {
        try {
            seekHandler.removeCallbacks(run);
        } catch (Exception e) {
            Log.e(TAG_ACTIVITY, "Error onPause seekHandler", e);
        }
        super.onPause();
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_HEADSETHOOK) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @NonNull
    private Boolean checkPermission() {
        String permission;
        if (Build.VERSION.SDK_INT >= 33) {
            permission = READ_MEDIA_AUDIO;
        } else if (Build.VERSION.SDK_INT >= 29) {
            permission = READ_EXTERNAL_STORAGE;
        } else {
            permission = WRITE_EXTERNAL_STORAGE;
        }
        if (ContextCompat.checkSelfPermission(NSoftsPlayerActivity.this, permission) != PackageManager.PERMISSION_GRANTED) {
            permissionLauncher.launch(permission);  // Request permission using the new API
            return false;
        }
        return true;
    }

    private final ActivityResultLauncher<String> permissionLauncher = registerForActivityResult(
            new ActivityResultContracts.RequestPermission(), isGranted ->
                    Toast.makeText(NSoftsPlayerActivity.this, Boolean.TRUE.equals(isGranted) ? "Permission granted"
                            : getResources().getString(R.string.err_cannot_use_features), Toast.LENGTH_SHORT).show()
    );
}
